/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class orbit5
extends PApplet {
    Planet[] p;
    int np = 0;
    float textX = 10.0f;
    float textY = 10.0f;
    int textDY = 0;
    float GM = 10000.0f;
    float sunX;
    float sunY;
    float sunR;
    boolean clockwise = true;
    boolean debug;
    boolean help = true;
    boolean lines;
    boolean tails = true;
    boolean names = true;
    boolean slow;
    boolean quit;
    boolean xyflag;
    int back = 64;
    int[] colorlist = new int[]{this.color(150, 150, 150), this.color(50, 150, 50), this.color(150, 200, 250), this.color(255, 200, 200), this.color(255, 127, 200), this.color(200, 200, 150), this.color(100, 100, 200), this.color(127, 200, 100)};
    String[] namelist = new String[]{"Mercury", "Venus", "Terra", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune"};
    float[] rplist = new float[]{1.0f, 4.0f, 4.0f, 2.0f, 15.0f, 12.0f, 10.0f, 10.0f};
    float[] rlist = new float[]{30.0f, 60.0f, 90.0f, 120.0f, 200.0f, 300.0f, 400.0f, 500.0f};

    public void setup() {
        this.size(1000, 800);
        this.sunX = this.width / 2;
        this.sunY = this.height / 2;
        this.sunR = 4.0f;
        this.p = new Planet[200];
    }

    public void restart() {
        this.np = 0;
        this.help = true;
        this.names = true;
        this.tails = true;
    }

    public void draw() {
        this.background(this.back);
        this.fill(255.0f, 155.0f, 0.0f);
        this.text("P L A N E T S", (float)(this.width / 2), 20.0f);
        if (this.np < 1) {
            this.text("Click for new planets;", (float)(this.width / 2), 40.0f);
            this.text("or enter p for", (float)(this.width / 2), 50.0f);
            this.text("Solar System", (float)(this.width / 2), 60.0f);
        }
        if (this.quit) {
            this.tryQuit();
        }
        this.frameRate(this.slow ? 2 : 30);
        this.fill(0);
        this.text(String.valueOf(this.np) + " planets", (float)(this.width - 100), 20.0f);
        this.textDY = 0;
        int n = 0;
        if (this.help) {
            this.help(this.width - 200, 50.0f);
        }
        this.sun();
        int n2 = 0;
        while (n2 < this.np) {
            this.p[n2].move();
            this.p[n2].show();
            if (this.debug) {
                this.p[n2].info(100.0f, 100 + 15 * n++);
            }
            ++n2;
        }
    }

    public void mousePressed() {
        this.nextline(String.valueOf(this.mouseX) + ", " + this.mouseY);
        this.fill(0);
        this.createPlanet(this.mouseX, this.mouseY);
    }

    public void tryQuit() {
        if (this.key == 'q' || this.key == 'Q') {
            this.fill(0);
            this.text("Q U I T   ???", this.sunX, this.sunY);
        } else if (this.key == 'y') {
            this.exit();
        } else {
            this.quit = false;
        }
    }

    public void keyPressed() {
        if (this.key == '?') {
            boolean bl = this.help = !this.help;
        }
        if (this.key == 'b') {
            int n = this.back < 1 ? 255 : (this.back = this.back > 64 ? this.back - 16 : this.back / 2);
        }
        if (this.key == 'd') {
            boolean bl = this.debug = !this.debug;
        }
        if (this.key == 'f') {
            boolean bl = this.slow = !this.slow;
        }
        if (this.key == 'F') {
            this.frameRate(0.2f);
        }
        if (this.key == 'l') {
            boolean bl = this.lines = !this.lines;
        }
        if (this.key == 'n') {
            boolean bl = this.names = !this.names;
        }
        if (this.key == 't') {
            boolean bl = this.tails = !this.tails;
        }
        if (this.key == 'x') {
            boolean bl = this.xyflag = !this.xyflag;
        }
        if (this.key == 'P' || this.key == 'p') {
            this.solarPlanets();
        }
        if (this.key == 'C' || this.key == 'c') {
            boolean bl = this.clockwise = !this.clockwise;
        }
        if (this.key == 'R' || this.key == 'r') {
            this.restart();
        }
        if (this.key == 'Q' || this.key == 'q') {
            if (this.quit) {
                this.exit();
            } else {
                this.quit = !this.quit;
            }
        }
    }

    public void help(float f, float f2) {
        int n = 0;
        this.fill(255.0f, 155.0f, 0.0f);
        this.text("?  Help", f, f2 + (float)(15 * n++));
        this.text("b  background darkens.", f, f2 + (float)(15 * n++));
        this.text("c  counterclockwise.", f, f2 + (float)(15 * n++));
        this.text("d  Debugging", f, f2 + (float)(15 * n++));
        this.text("f  frame rate (2 per second)", f, f2 + (float)(15 * n++));
        this.text("F  Freeze (5 seconds)", f, f2 + (float)(15 * n++));
        this.text("l  Lines (from sun to planet)", f, f2 + (float)(15 * n++));
        this.text("n  names (displayed with planet)", f, f2 + (float)(15 * n++));
        this.text("t  tails (from previous position)", f, f2 + (float)(15 * n++));
        this.text("x  xyflag (create planets from (x,y) rather than r,theta)", f, f2 + (float)(15 * n++));
        this.text("----", f, f2 + (float)(15 * n++));
        this.text("P  Populate with solar planets", f, f2 + (float)(15 * n++));
        this.text("R  Restart", f, f2 + (float)(15 * n++));
        this.text("Q  Quit", f, f2 + (float)(15 * n++));
        this.text("", f, f2 + (float)(15 * n++));
        this.text("Click to create a new planet", f, f2 + (float)(15 * n++));
    }

    public void sun() {
        this.fill(255.0f, 255.0f, 0.0f);
        this.ellipseMode(2);
        this.ellipse(this.sunX, this.sunY, this.sunR, this.sunR);
    }

    public void nextline(String string) {
        this.text(string, this.textX, this.textY + (float)(15 * this.textDY++));
    }

    public void createPlanet(float f, float f2) {
        if (this.np >= this.p.length) {
            this.background(255);
            String string = "TOO MANY PLANETS!  Press R key to reset.";
            this.text(string, 10.0f, 10.0f);
            this.text(string, 10.0f, (float)(this.height / 4));
            this.text(string, 10.0f, (float)(this.height / 2));
            this.fill(0);
            this.text(string, 10.0f, 30.0f);
            this.text(string, (float)(this.width / 2), (float)(this.height / 4));
            this.text(string, (float)(this.width / 2), (float)(this.height / 2));
            return;
        }
        float f3 = orbit5.dist(f, f2, this.sunX, this.sunY);
        if (this.xyflag) {
            this.p[this.np] = new Planet(f, f2);
        } else {
            float f4 = orbit5.atan((f2 - this.sunY) / (f - this.sunX));
            if (f < this.sunX) {
                f4 += (float)Math.PI;
            }
            this.p[this.np] = new Planet(f3);
            this.p[this.np].theta = f4;
        }
        int n = this.p[this.np].c = this.np < this.colorlist.length ? this.colorlist[this.np] : this.color(this.random(255.0f), this.random(255.0f), this.random(255.0f));
        if (this.np < this.namelist.length) {
            this.p[this.np].name = this.namelist[this.np];
        }
        this.p[this.np].name = this.xyflag ? "Planet-XY " : "Unknown ";
        this.p[this.np].name = String.valueOf(this.p[this.np].name) + this.np;
        this.p[this.np].pR = 2.0f + this.random(10.0f);
        ++this.np;
    }

    public void solarPlanets() {
        int n = 0;
        while (n < 8 && this.np < this.p.length) {
            this.createSolar(n, 0.0f);
            ++n;
        }
        this.p[5].ring = 3.0f;
        this.p[4].ring = 1.0E-4f;
    }

    public void createSolar(int n, float f) {
        if (n > this.rlist.length) {
            return;
        }
        this.p[this.np] = new Planet(this.rlist[n]);
        this.p[this.np].theta = 0.0f;
        String string = n < this.namelist.length ? this.namelist[n] : "Unknown " + this.np;
        this.p[this.np].name = this.clockwise ? string : "Anti-" + string;
        this.p[this.np].pR = this.rplist[n];
        int n2 = n < this.colorlist.length ? this.colorlist[n] : this.color(this.random(255.0f), this.random(255.0f), this.random(255.0f));
        this.p[this.np].c = this.clockwise ? n2 : n2 - 0x404040;
        ++this.np;
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#D4D0C8", "orbit5"});
    }

    class Planet {
        boolean initialized = false;
        private float r = 150.0f;
        float d = (float)Math.PI * 2 * this.r;
        float period = 3.1536E7f;
        private float v;
        float theta;
        float dtheta;
        private float x;
        private float y;
        float dx;
        float dy;
        String name;
        float pR;
        int c;
        int cNite;
        float ring;
        float oldx;
        float oldy;

        Planet() {
            this.v = orbit5.sqrt(orbit5.this.GM / this.r);
            this.theta = 0.0f;
            this.dtheta = this.v / this.r;
            this.x = orbit5.this.sunX + this.r;
            this.y = orbit5.this.sunY;
            this.name = "Unknown";
            this.pR = 6.0f;
            this.c = orbit5.this.color(200, 255, 255);
            this.cNite = orbit5.this.color(100, 100, 100);
            this.ring = 0.0f;
            this.pDetails();
        }

        Planet(float f) {
            this.v = orbit5.sqrt(orbit5.this.GM / this.r);
            this.theta = 0.0f;
            this.dtheta = this.v / this.r;
            this.x = orbit5.this.sunX + this.r;
            this.y = orbit5.this.sunY;
            this.name = "Unknown";
            this.pR = 6.0f;
            this.c = orbit5.this.color(200, 255, 255);
            this.cNite = orbit5.this.color(100, 100, 100);
            this.ring = 0.0f;
            this.r = f;
            this.theta = 0.0f;
            this.rCreate();
        }

        Planet(float f, float f2) {
            this.v = orbit5.sqrt(orbit5.this.GM / this.r);
            this.theta = 0.0f;
            this.dtheta = this.v / this.r;
            this.x = orbit5.this.sunX + this.r;
            this.y = orbit5.this.sunY;
            this.name = "Unknown";
            this.pR = 6.0f;
            this.c = orbit5.this.color(200, 255, 255);
            this.cNite = orbit5.this.color(100, 100, 100);
            this.ring = 0.0f;
            this.x = f;
            this.y = f2;
            this.xyCreate();
        }

        public void rCreate() {
            this.x = orbit5.this.sunX + this.r * orbit5.cos(this.theta);
            this.y = orbit5.this.sunY + this.r * orbit5.sin(this.theta);
            this.v = orbit5.sqrt(orbit5.this.GM / this.r);
            this.v = orbit5.this.clockwise ? this.v : -this.v;
            this.pDetails();
        }

        public void xyCreate() {
            this.r = orbit5.dist(this.x, this.y, orbit5.this.sunX, orbit5.this.sunY);
            this.v = orbit5.sqrt(orbit5.this.GM / this.r);
            this.v = orbit5.this.clockwise ? this.v : -this.v;
            this.theta = orbit5.atan((this.y - orbit5.this.sunY) / (this.x - orbit5.this.sunX));
            this.dtheta = this.v / this.r;
            this.pDetails();
        }

        public void pDetails() {
            this.v = orbit5.sqrt(orbit5.this.GM / this.r);
            this.v = orbit5.this.clockwise ? this.v : -this.v;
            this.dtheta = this.v / this.r;
            this.d = (float)Math.PI * 2 * this.r;
            if (this.c == 0) {
                this.c = orbit5.this.color(orbit5.this.random(255.0f), orbit5.this.random(255.0f), orbit5.this.random(255.0f));
            }
            if (this.name == "") {
                this.name = "Unknown #" + orbit5.this.np;
            }
            if (this.pR == 0.0f) {
                this.pR = 2.0f + orbit5.this.random(30.0f);
            }
        }

        public void move() {
            this.oldx = this.x;
            this.oldy = this.y;
            this.theta %= (float)Math.PI * 2;
            this.x = orbit5.this.sunX + this.r * orbit5.cos(this.theta);
            this.y = orbit5.this.sunY + this.r * orbit5.sin(this.theta);
            this.dx = this.x - this.oldx;
            this.dy = this.y - this.oldx;
            this.theta += this.dtheta;
        }

        public void show() {
            orbit5.this.fill(this.c);
            orbit5.this.ellipseMode(2);
            orbit5.this.ellipse(this.x, this.y, this.pR, this.pR);
            if (this.ring > 0.0f) {
                orbit5.this.noFill();
                if (this.ring > 0.0f) {
                    orbit5.this.stroke(this.ring > 1.0f ? 240 : 200);
                    orbit5.this.strokeWeight(this.ring);
                    orbit5.this.arc(this.x, this.y, 1.5f * this.pR, 0.25f * this.pR + this.ring, -0.7853982f, 3.926991f);
                    orbit5.this.strokeWeight(1.0f);
                    orbit5.this.noStroke();
                }
            }
            if (orbit5.this.names) {
                orbit5.this.text(this.name, this.x + this.pR, this.y - 5.0f);
            }
            if (orbit5.this.tails) {
                orbit5.this.stroke(255.0f, 0.0f, 0.0f);
                orbit5.this.line(this.oldx - 2.0f * (this.x - this.oldx), this.oldy - 2.0f * (this.y - this.oldy), this.x, this.y);
                orbit5.this.text("...v=" + this.v, this.oldx - 2.0f * (this.x - this.oldx), this.oldy - 2.0f * (this.y - this.oldy));
                orbit5.this.stroke(0);
            }
            if (orbit5.this.debug) {
                orbit5.this.text("(" + this.x + ", " + this.y + ")", this.x + this.pR, this.y + 15.0f);
                orbit5.this.text("r:  " + this.r + "  theta=" + this.theta, this.x + this.pR, this.y + 30.0f);
                orbit5.this.text("v:  " + this.v, this.x + this.pR, this.y + 45.0f);
            }
            if (orbit5.this.lines) {
                orbit5.this.line(orbit5.this.sunX, orbit5.this.sunY, this.x, this.y);
            }
        }

        public void info(float f, float f2) {
            float f3;
            orbit5.this.text(this.name, f + 20.0f, f2);
            f += 70.0f;
            String string = "";
            string = String.valueOf(string) + "      v=" + this.roundto(this.v, 4);
            string = String.valueOf(string) + "      d=" + this.roundto(this.d, 4);
            string = String.valueOf(string) + "      r=" + this.r;
            string = String.valueOf(string) + "      theta=" + this.roundto(this.theta, 4);
            string = String.valueOf(string) + "      (" + this.roundto(this.x, 4) + "," + this.roundto(this.y, 4) + ")";
            if (this.ring > 0.0f) {
                string = String.valueOf(string) + "       ring=" + this.ring;
            }
            if (orbit5.abs(f3 = this.r - orbit5.sqrt(orbit5.sq(this.x - orbit5.this.sunX) + orbit5.sq(this.y - orbit5.this.sunY))) > this.r * 1.0E-4f) {
                string = String.valueOf(string) + "       rr=" + f3;
            }
            orbit5.this.text(string, f, f2);
        }

        public float roundto(float f, int n) {
            float f2 = orbit5.pow(10.0f, n);
            return (float)orbit5.round(f * f2) / f2;
        }
    }
}

